% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary.R
\name{plot.summary_fitsae}
\alias{plot.summary_fitsae}
\title{Plot Function for a \code{summary_fitsae} Object}
\usage{
\method{plot}{summary_fitsae}(
  x,
  size = 2.5,
  alpha = 0.8,
  n_bins = 15,
  grid = TRUE,
  label_names = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class \code{summary_fitsae}.}

\item{size}{Aesthetic option denoting the size of scatterplots points, see \code{\link[ggplot2]{geom_point}} documentation.}

\item{alpha}{Aesthetic option denoting the opacity of scatterplots points, see \code{\link[ggplot2]{geom_point}} documentation.}

\item{n_bins}{Denoting the number of bins used for histogram.}

\item{grid}{Logical indicating whether plots are displayed in a grid (\code{TRUE}) or in sequence (\code{FALSE}).}

\item{label_names}{Character string indicating the model name to display in boxplot x-axis label.}

\item{...}{Currently unused.}
}
\value{
Four \code{ggplot2} objects in a grid.
}
\description{
The generic method \code{plot()} provides, in a grid (default) or sequence, (a) a scatterplot of direct estimates versus model-based estimates, visually capturing the shrinking process, (b) a Bayesian P-values histogram, (c) a boxplot of standard deviation reduction values, and, if areas sample sizes are provided as input in \code{fit_sae()}, (d) a scatterplot of model residuals versus sample sizes, in order to check for design-consistency i.e., as long as sizes increase residuals should converge to zero.
}
\examples{
library(tipsae)

# loading toy dataset
data("emilia_cs")

# fitting a model
fit_beta <- fit_sae(formula_fixed = hcr ~ x, data = emilia_cs, domains = "id",
                    type_disp = "var", disp_direct = "vars", domain_size = "n",
                    # MCMC setting to obtain a fast example. Remove next line for reliable results.
                    chains = 1, iter = 300, seed = 0)

# check model diagnostics
summ_beta <- summary(fit_beta)

# visualize diagnostics via plot() method
plot(summ_beta)

}
\seealso{
\code{\link{summary.fitsae}} to produce the input object.
}
