% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_plots.R
\name{draw_pca}
\alias{draw_pca}
\title{draw PCA plots}
\usage{
draw_pca(
  exp,
  group_list,
  color = c("#2874C5", "#f87669", "#e6b707", "#868686", "#92C5DE", "#F4A582", "#66C2A5",
    "#FC8D62", "#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F", "#E5C494", "#B3B3B3"),
  addEllipses = TRUE,
  style = "default",
  color.label = "Group",
  title = "",
  ...
)
}
\arguments{
\item{exp}{A numeric matrix}

\item{group_list}{A factor with duplicated character or factor}

\item{color}{color vector}

\item{addEllipses}{logical,add ellipses or not}

\item{style}{plot style,"default","ggplot2"and "3D"}

\item{color.label}{color legend label}

\item{title}{plot title}

\item{...}{other paramters from fviz_pca_ind}
}
\value{
a pca plot according to \code{exp} and grouped by \code{group}.
}
\description{
do PCA analysis and print a PCA plot
}
\examples{
draw_pca(t(iris[,1:4]),iris$Species)
draw_pca(t(iris[,1:4]),iris$Species,style = "ggplot2")
draw_pca(t(iris[,1:4]),iris$Species,style = "3D")
#change color
draw_pca(t(iris[,1:4]),iris$Species,color = c("#E78AC3", "#A6D854", "#FFD92F"))
}
\seealso{
\code{\link{draw_heatmap}};\code{\link{draw_volcano}};\code{\link{draw_venn}}
}
\author{
Xiaojie Sun
}
