% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_xml.R
\name{to_xml}
\alias{to_xml}
\title{Transform file to XML}
\usage{
to_xml(
  path,
  encoding = "UTF-8",
  sourcepos = FALSE,
  anchor_links = TRUE,
  unescaped = TRUE
)
}
\arguments{
\item{path}{Path to the file.}

\item{encoding}{Encoding to be used by readLines.}

\item{sourcepos}{passed to \code{\link[commonmark:commonmark]{commonmark::markdown_xml()}}. If \code{TRUE}, the
source position of the file will be included as a "sourcepos" attribute.
Defaults to \code{FALSE}.}

\item{anchor_links}{if \code{TRUE} (default), reference-style links with anchors
(in the style of \verb{[key]: https://example.com/link "title"}) will be
preserved as best as possible. If this is \code{FALSE}, the anchors disappear
and the links will appear as normal links. See \code{\link[=resolve_anchor_links]{resolve_anchor_links()}} for
details.}

\item{unescaped}{if \code{TRUE} (default) AND \code{sourcepos = TRUE}, square braces
that were unescaped in the original document will be preserved as best as
possible. If this is \code{FALSE}, these braces will be escaped in the output
document. See \code{\link[=protect_unescaped]{protect_unescaped()}} for details.}
}
\value{
A list containing the front-matter (YAML, TOML or JSON)
of the file (frontmatter)
and its body (body) as XML.
}
\description{
Transform file to XML
}
\details{
This function will take a (R)markdown file, split the frontmatter
from the body, and read in the body through \code{\link[commonmark:commonmark]{commonmark::markdown_xml()}}.
Any RMarkdown code fences will be parsed to expose the chunk options in
XML and tickboxes (aka checkboxes) in GitHub-flavored markdown will be
preserved (both modifications from the commonmark standard).
}
\note{
Math elements are not protected by default. You can use \code{\link[=protect_math]{protect_math()}} to
address this if needed.
}
\examples{
path <- system.file("extdata", "example1.md", package = "tinkr")
post_list <- to_xml(path)
names(post_list)
path2 <- system.file("extdata", "example2.Rmd", package = "tinkr")
post_list2 <- to_xml(path2)
post_list2
}
