% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.R
\name{native_areas}
\alias{native_areas}
\title{Download an American Indian / Alaska Native / Native Hawaiian Areas shapefile into R.}
\usage{
native_areas(cb = FALSE, year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year; defaults to 2022}

\item{...}{arguments to be passed to internal function \code{load_tiger}, which is not exported. See Additional Arguments.}
}
\description{
Description from the Census Bureau: "This shapefile contain both legal and statistical
American Indian, Alaska Native, and Native Hawaiian
entities for which the Census Bureau publishes data. The legal entities consist of federally recognized
American Indian reservations and off-reservation trust land areas, state-recognized American Indian
reservations, and Hawaiian home lands (HHLs)." For more information, please see the link provided.
}
\section{Additional Arguments}{

Additional arguments that can be passed in \code{...} are:
\itemize{
\item \code{class} Desired class of return object: \code{"sf"} (the default) or \code{"sp"}.  sp classes should be considered deprecated as of tigris version 2.0, but legacy support is still available.
\item \code{progress_bar} If set to \code{FALSE}, do not display download progress bar (helpful for R Markdown documents). Defaults to \code{TRUE}.
\item \code{keep_zipped_shapefile} If set to \code{TRUE}, do not delete zipped shapefile (stored in temporary directory or \code{TIGRIS_CACHE_DIR}
depending on the configuration of global option \code{"tigris_use_cache"}). Defaults to \code{FALSE}.
\item \code{refresh} Whether to re-download cached shapefiles (\code{TRUE} or \code{FALSE}) . The default is either \code{FALSE} or the value of global
option \code{"tigris_refresh"} if it is set. Specifying this argument will override the behavior set in \code{"tigris_refresh"} global option.
\item \code{filter_by} Geometry used to filter the output returned by the function.  Can be an sf object, an object of class \code{bbox}, or a length-4 vector of format \code{c(xmin, ymin, xmax, ymax)} that can be converted to a bbox. Geometries that intersect the input to \code{filter_by} will be returned.
}
}

\examples{
\dontrun{
library(tigris)
library(ggplot2)
library(ggthemes)

nat <- native_areas(cb = TRUE)

gg <- ggplot()
gg <- gg + geom_sf(data = nat, color="black", fill="white", size=0.25)
gg <- gg + coord_sf(xlim=c(-179.1506, -129.9795),  # alaska
                     ylim=c(51.2097, 71.4410))
gg <- gg + theme_map()
gg
}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/reference/GARM/Ch5GARM.pdf}

Other native/tribal geometries functions: 
\code{\link{alaska_native_regional_corporations}()},
\code{\link{tribal_block_groups}()},
\code{\link{tribal_census_tracts}()},
\code{\link{tribal_subdivisions_national}()}
}
\concept{native/tribal geometries functions}
