% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metro_areas.R
\name{new_england}
\alias{new_england}
\title{Download a New England City and Town Area shapefile into R}
\usage{
new_england(type = "necta", cb = FALSE, year = NULL, ...)
}
\arguments{
\item{type}{Specify whether to download the New England City and Town Areas file (\code{'necta'}, the default),
the combined NECTA file (\code{'combined'}), or the NECTA divisions file (\code{'divisions'}).}

\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
cartographic boundary file.  Defaults to FALSE (the most detailed
TIGER/Line file).  Only available when \code{type = 'necta'}.}

\item{year}{The data year (defaults to 2019).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{class}, which can be set to \code{"sf"} (the default) or \code{"sp"} to
request sf or sp class objects, and \code{refresh}, which specifies whether or
not to re-download shapefiles (defaults to \code{FALSE}).}
}
\description{
From the US Census Bureau (see link for source): "In New England
(Connecticut, Maine, Massachusetts, New Hampshire, Rhode Island,
and Vermont), the OMB has defined an alternative county subdivision
(generally city and town) based definition of CBSAs
known as New England city and town areas (NECTAs). NECTAs are defined using the same criteria as
metropolitan and micropolitan statistical areas and are identified as either metropolitan or micropolitan,
based, respectively, on the presence of either an urbanized area of 50,000 or more inhabitants or an
urban cluster of at least 10,000 and less than 50,000 inhabitants."  Combined NECTAs, or CNECTAs, are two or more
NECTAs that have significant employment interchange, like Combined Statistical Areas;
NECTA divisions are subdivisions of NECTAs.
}
\examples{
\dontrun{
library(tigris)

ne <- new_england(cb = TRUE)

plot(ne$geometry)

}
}
\seealso{
\url{https://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2019/TGRSHP2019_TechDoc.pdf}

Other metro area functions: 
\code{\link{combined_statistical_areas}()},
\code{\link{core_based_statistical_areas}()},
\code{\link{metro_divisions}()},
\code{\link{urban_areas}()}
}
\concept{metro area functions}
