% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/native.R
\name{alaska_native_regional_corporations}
\alias{alaska_native_regional_corporations}
\title{Download an Alaska Native Regional Corporation shapefile into R.}
\usage{
alaska_native_regional_corporations(cb = FALSE, year = NULL, ...)
}
\arguments{
\item{cb}{If cb is set to TRUE, download a generalized (1:500k)
file.  Defaults to FALSE (the most detailed TIGER/Line file)}

\item{year}{the data year (defaults to 2015).}

\item{...}{arguments to be passed to the underlying `load_tiger` function, which is not exported.
Options include \code{refresh}, which specifies whether or not to re-download shapefiles
(defaults to \code{FALSE}).}
}
\description{
From the US Census Bureau: "ANRCs are corporations created according to the Alaska Native Claims Settlement Act.
They are organized under the laws of the State of
Alaska as "Regional Corporations," to conduct both the for-profit and non-profit affairs of Alaska Natives
within defined regions of Alaska."  For more information, please see the Census technical documentation at the
link provided.
}
\seealso{
\url{http://www2.census.gov/geo/pdfs/maps-data/data/tiger/tgrshp2015/TGRSHP2015_TechDoc.pdf}

Other native/tribal geometries functions: \code{\link{native_areas}},
  \code{\link{tribal_block_groups}},
  \code{\link{tribal_census_tracts}},
  \code{\link{tribal_subdivisions_national}}
}
