% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{observed}
\alias{observed}
\alias{observed.data.frame}
\title{Specify observed dataset and variables for VPC}
\usage{
observed(o, ...)

\method{observed}{data.frame}(
  o,
  x,
  yobs,
  pred = NULL,
  blq = NULL,
  lloq = -Inf,
  alq = NULL,
  uloq = Inf,
  ...
)
}
\arguments{
\item{o}{A \code{data.frame} of observation data.}

\item{...}{Other arguments.}

\item{x}{Numeric x-variable, typically named TIME.}

\item{yobs}{Numeric y-variable, typically named DV.}

\item{pred}{Population prediction variable, typically named PRED.}

\item{blq}{Logical variable indicating below limit of quantification.}

\item{lloq}{Number or numeric variable in data indicating the lower limit of quantification.}

\item{alq}{Logical variable indicating above limit of quantification .}

\item{uloq}{Number or numeric variable in data indicating the upper limit of quantification.}
}
\value{
A \code{tidyvpcobj} containing both original data and observed data formatted with \code{x} and \code{y} variables as specified in function.
  Resulting data is of class \code{data.frame} and \code{data.table}.
}
\description{
The observed function is the first function in the vpc piping chain and is used for specifying observed data and variables for VPC. Note: Observed
data must not contain missing DV and may require filtering \code{MDV == 0} before generating VPC.
}
\examples{

obs_data <- obs_data[MDV == 0]
sim_data <- sim_data[MDV == 0]

vpc <- observed(obs_data, x=TIME, y=DV)

}
\seealso{
\code{\link{simulated}} \code{\link{censoring}} \code{\link{stratify}} \code{\link{predcorrect}} \code{\link{binning}} \code{\link{binless}} \code{\link{vpcstats}}
}
