% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice-Spat.R
\name{slice.Spat}
\alias{slice.Spat}
\alias{slice.SpatRaster}
\alias{slice.SpatVector}
\alias{slice_head.SpatRaster}
\alias{slice_head.SpatVector}
\alias{slice_tail.SpatRaster}
\alias{slice_tail.SpatVector}
\alias{slice_min.SpatRaster}
\alias{slice_min.SpatVector}
\alias{slice_max.SpatRaster}
\alias{slice_max.SpatVector}
\alias{slice_sample.SpatRaster}
\alias{slice_sample.SpatVector}
\alias{slice_rows}
\alias{slice_rows.SpatRaster}
\alias{slice_cols}
\alias{slice_cols.SpatRaster}
\alias{slice_colrows}
\alias{slice_colrows.SpatRaster}
\title{Subset cells/rows/columns/geometries using their positions}
\usage{
\method{slice}{SpatRaster}(.data, ..., .preserve = FALSE, .keep_extent = FALSE)

\method{slice}{SpatVector}(.data, ..., .preserve = FALSE)

\method{slice_head}{SpatRaster}(.data, ..., n, prop, .keep_extent = FALSE)

\method{slice_head}{SpatVector}(.data, ..., n, prop)

\method{slice_tail}{SpatRaster}(.data, ..., n, prop, .keep_extent = FALSE)

\method{slice_tail}{SpatVector}(.data, ..., n, prop)

\method{slice_min}{SpatRaster}(
  .data,
  order_by,
  ...,
  n,
  prop,
  with_ties = TRUE,
  .keep_extent = FALSE,
  na.rm = TRUE
)

\method{slice_min}{SpatVector}(.data, order_by, ..., n, prop, with_ties = TRUE, na_rm = FALSE)

\method{slice_max}{SpatRaster}(
  .data,
  order_by,
  ...,
  n,
  prop,
  with_ties = TRUE,
  .keep_extent = FALSE,
  na.rm = TRUE
)

\method{slice_max}{SpatVector}(.data, order_by, ..., n, prop, with_ties = TRUE, na_rm = FALSE)

\method{slice_sample}{SpatRaster}(
  .data,
  ...,
  n,
  prop,
  weight_by = NULL,
  replace = FALSE,
  .keep_extent = FALSE
)

\method{slice_sample}{SpatVector}(.data, ..., n, prop, weight_by = NULL, replace = FALSE)

slice_rows(.data, ...)

\method{slice_rows}{SpatRaster}(.data, ..., .keep_extent = FALSE)

slice_cols(.data, ...)

\method{slice_cols}{SpatRaster}(.data, ..., .keep_extent = FALSE)

slice_colrows(.data, ...)

\method{slice_colrows}{SpatRaster}(.data, ..., cols, rows, .keep_extent = FALSE, inverse = FALSE)
}
\arguments{
\item{.data}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{\code{\link[dplyr:slice]{data-masking}} Integer row values. Provide
either positive values to keep, or negative values to drop.

The values provided must be either all positive or all negative. Indices
beyond the number of rows in the input are silently ignored.
See \strong{Methods}.}

\item{.preserve}{Ignored for Spat* objects}

\item{.keep_extent}{Should the extent of the resulting SpatRaster be kept?
See also \code{\link[terra:trim]{terra::trim()}}, \code{\link[terra:extend]{terra::extend()}}.}

\item{n, prop}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used. If \code{n} is greater than the number of rows in the group
(or \code{prop > 1}), the result will be silently truncated to the group size.
\code{prop} will be rounded towards zero to generate an integer number of
rows.

A negative value of \code{n} or \code{prop} will be subtracted from the group
size. For example, \code{n = -2} with a group of 5 rows will select 5 - 2 = 3
rows; \code{prop = -0.25} with 8 rows will select 8 * (1 - 0.25) = 6 rows.}

\item{order_by}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Variable or function
of variables to order by. To order by multiple variables, wrap them in a
data frame or tibble.}

\item{with_ties}{Should ties be kept together? The default, \code{TRUE},
may return more rows than you request. Use \code{FALSE} to ignore ties,
and return the first \code{n} rows.}

\item{na.rm}{Logical, should cells that present a value of \code{NA} removed when
computing \code{slice_min()/slice_max()}?. The default is \code{TRUE}.}

\item{na_rm}{Should missing values in \code{order_by} be removed from the result?
If \code{FALSE}, \code{NA} values are sorted to the end (like in \code{\link[dplyr:arrange]{arrange()}}), so
they will only be included if there are insufficient non-missing values to
reach \code{n}/\code{prop}.}

\item{weight_by}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Sampling weights.
This must evaluate to a vector of non-negative numbers the same length as
the input. Weights are automatically standardised to sum to 1.}

\item{replace}{Should sampling be performed with (\code{TRUE}) or without
(\code{FALSE}, the default) replacement.}

\item{cols, rows}{Integer col/row values of the SpatRaster}

\item{inverse}{If \code{TRUE}, \code{.data} is inverse-masked to the given selection.
See \code{\link[terra:mask]{terra::mask()}}.}
}
\value{
A Spat* object  of the same class than \code{.data}. See \strong{Methods}.
}
\description{
\code{slice()} lets you index cells/rows/columns/geometries by their (integer)
locations. It allows you to select, remove, and duplicate those dimensions
of a Spat* object.

\strong{If you want to slice your SpatRaster by geographic coordinates} use
\code{\link[=filter.SpatRaster]{filter.SpatRaster()}} method.

It is accompanied by a number of helpers for common use cases:
\itemize{
\item \code{slice_head()} and \code{slice_tail()} select the first or last
cells/geometries.
\item \code{slice_sample()} randomly selects cells/geometries.
\item \code{slice_rows()} and \code{slice_cols()} allow to subset entire rows or columns,
of a SpatRaster.
\item \code{slice_colrows()} subsets regions of the raster by row and column position
of a SpatRaster.
}

You can get a skeleton of your SpatRaster with the cell, column and row
index with \code{\link[=as_coordinates]{as_coordinates()}}.

See \strong{Methods} for details.
}
\section{terra equivalent}{


\code{\link[terra:subset]{terra::subset()}}, \code{\link[terra:sample]{terra::spatSample()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:slice]{dplyr::slice()}} function.
\subsection{SpatRaster}{

The result is a SpatRaster with the crs and resolution of the input and
where cell values of the selected cells/columns/rows are preserved.

Use \code{.keep_extent = TRUE} to preserve the extent of \code{.data} on the output.
The non-selected cells would present a value of \code{NA}.
}

\subsection{SpatVector}{

The result is a SpatVector where the attributes of the selected
geometries are preserved. If \code{.data} is a
\link[=is_grouped_spatvector]{grouped SpatVector}, the operation will be performed
on each group, so that (e.g.) \code{slice_head(df, n = 5)} will select the first
five rows in each group.
}
}

\examples{


library(terra)

f <- system.file("extdata/cyl_temp.tif", package = "tidyterra")
r <- rast(f)

# Slice first 100 cells
r \%>\%
  slice(1:100) \%>\%
  plot()

# Rows
r \%>\%
  slice_rows(1:30) \%>\%
  plot()

# Cols
r \%>\%
  slice_cols(-(20:50)) \%>\%
  plot()

# Spatial sample
r \%>\%
  slice_sample(prop = 0.2) \%>\%
  plot()


# Slice regions
r \%>\%
  slice_colrows(
    cols = c(20:40, 60:80),
    rows = -c(1:20, 30:50)
  ) \%>\%
  plot()

# Group wise operation with SpatVectors--------------------------------------
v <- terra::vect(system.file("ex/lux.shp", package = "terra"))

\donttest{
glimpse(v) \%>\% autoplot(aes(fill = NAME_1))

gv <- v \%>\% group_by(NAME_1)
# All slice helpers operate per group, silently truncating to the group size
gv \%>\%
  slice_head(n = 1) \%>\%
  glimpse() \%>\%
  autoplot(aes(fill = NAME_1))
gv \%>\%
  slice_tail(n = 1) \%>\%
  glimpse() \%>\%
  autoplot(aes(fill = NAME_1))
gv \%>\%
  slice_min(AREA, n = 1) \%>\%
  glimpse() \%>\%
  autoplot(aes(fill = NAME_1))
gv \%>\%
  slice_max(AREA, n = 1) \%>\%
  glimpse() \%>\%
  autoplot(aes(fill = NAME_1))
}
}
\seealso{
\code{\link[dplyr:slice]{dplyr::slice()}}, \code{\link[terra:sample]{terra::spatSample()}}.

You can get a skeleton of your SpatRaster with the cell, column and row
index with \code{\link[=as_coordinates]{as_coordinates()}}.

If you want to slice by geographic coordinates use \code{\link[=filter.SpatRaster]{filter.SpatRaster()}}.

Other single table verbs: 
\code{\link{arrange.SpatVector}()},
\code{\link{filter.Spat}},
\code{\link{mutate.Spat}},
\code{\link{rename.Spat}},
\code{\link{select.Spat}},
\code{\link{summarise.SpatVector}()}

Other dplyr verbs that operate on rows:
\code{\link{arrange.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter.Spat}}

Other dplyr methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.methods}
\concept{dplyr.rows}
\concept{single table verbs}
