% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_else.R
\name{ifelse.}
\alias{ifelse.}
\title{Fast ifelse}
\usage{
ifelse.(conditions, true, false, na = NA)
}
\arguments{
\item{conditions}{Conditions to test on}

\item{true}{Values to return if conditions evaluate to \code{TRUE}}

\item{false}{Values to return if conditions evaluate to \code{FALSE}}

\item{na}{Value to return if an element of test is \code{NA}}
}
\description{
Fast version of \code{base::ifelse()}.
}
\examples{
x <- 1:5
ifelse(x < 3, 1, 0)

# Can also be used inside of mutate()
df <- data.table(x = x)

df \%>\%
  mutate(new_col = ifelse(x < 3, 1, 0))
}
\keyword{internal}
