% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/where.R
\name{where}
\alias{where}
\title{Select variables with a function}
\usage{
where(fn)
}
\arguments{
\item{fn}{A function that returns `TRUE` or `FALSE` (technically, a
_predicate_ function). Can also be a purrr-like formula.}
}
\description{
This selection helper selects the variables for which a
function returns `TRUE`.
}
\examples{
iris \%>\% select.(where(is.factor))

iris \%>\% select.(where(is.numeric))

## The formula shorthand
# These expressions are equivalent:

iris \%>\% select.(where(is.numeric))

iris \%>\% select.(where(function(x) is.numeric(x)))

iris \%>\% select.(where(~ is.numeric(.x)))

# This shortahand is useful for adding logic inline.
# Here we select all numeric variables whose mean is greater than 3.5:
iris \%>\%
  select.(where(~ is.numeric(.x) && mean(.x) > 3.5))

}
