% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest.R
\name{unnest.}
\alias{unnest.}
\alias{dt_unnest_legacy}
\title{Unnest a nested data.table}
\usage{
unnest.(.df, ...)

dt_unnest_legacy(.df, ...)
}
\arguments{
\item{.df}{A nested data.table}

\item{...}{Columns to unnest. If empty, unnests all list columns. \code{tidyselect} compatible.}
}
\description{
Unnest a nested data.table.
}
\examples{
nested_df <- data.table(
  a = 1:10,
  b = 11:20,
  c = c(rep("a", 6), rep("b", 4)),
  d = c(rep("a", 4), rep("b", 6))) \%>\%
  nest_by.(c, d) \%>\%
  mutate.(pulled_vec = map.(data, ~ pull.(.x, a)))

nested_df \%>\%
  unnest.(data)

nested_df \%>\%
  unnest.(data, pulled_vec)
}
