% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice_sample.R
\name{slice_sample.}
\alias{slice_sample.}
\title{Choose rows in a data.table}
\usage{
slice_sample.(
  .df,
  n,
  prop,
  weight_by = NULL,
  replace = FALSE,
  .by = NULL,
  by = NULL
)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{n}{Number of rows to grab}

\item{prop}{The proportion of rows to select}

\item{weight_by}{Sampling weights}

\item{replace}{Should sampling be performed with (\code{TRUE}) or without (\code{FALSE}, default) replacement}

\item{.by, by}{Columns to group by}
}
\description{
Choose rows in a data.table.
Grouped data.tables grab rows within each group.
}
\examples{
df <- data.table(
  x = 1:4,
  y = 5:8,
  z = c("a", "a", "a", "b")
)

df \%>\%
  slice(1:3)

df \%>\%
  slice(1, 3)

df \%>\%
  slice(1:2, .by = z)

df \%>\%
  slice_head(1, .by = z)

df \%>\%
  slice_tail(1, .by = z)

df \%>\%
  slice_max(order_by = x, .by = z)

df \%>\%
  slice_min(order_by = y, .by = z)
}
\keyword{internal}
