% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_descriptives.r
\name{report_descriptives}
\alias{report_descriptives}
\alias{M}
\alias{SD}
\title{Report descriptives helper functions}
\usage{
M(identifier, var = NULL, group = NULL,
  results = getOption("tidystats_list"))

SD(identifier, var = NULL, group = NULL,
  results = getOption("tidystats_list"))
}
\arguments{
\item{identifier}{A character string identifying the descriptives.}

\item{var}{A character string identifying the exact variable, if needed.}

\item{group}{A character string identifiying the group, if needed.}

\item{results}{A tidystats list.}
}
\description{
Report descriptives helper functions
}
\examples{
# Read in a list of results
descriptives <- read_stats(system.file("descriptives.csv",
  package = "tidystats"))

options(tidystats_list = descriptives)

# Report the mean
M("D4_avoidance")
M("D5_avoidance_anxiety", var = "avoidance")

# Report the standard deviation
SD("D4_avoidance")

}
