% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_anova.R
\name{report_anova}
\alias{report_anova}
\title{Report method for ANOVA models}
\usage{
report_anova(results, identifier, term = NULL, term_nr = NULL,
  statistic = NULL)
}
\arguments{
\item{results}{A tidy stats list.}

\item{identifier}{A character string identifying the model.}

\item{term}{A character string indicating which term you want to report the statistics of.}

\item{term_nr}{A number indicating which term you want to report the the statistics of.}

\item{statistic}{A character string of a statistic you want to extract from a model.}
}
\description{
Function to report ANOVA output in APA style.
}
\examples{
# Read in a list of results
results <- read_stats(system.file("results.csv", package = "tidystats"))

# Report results
report(results, identifier = "ANOVA", term = "N")
report(results, identifier = "ANOVA", term_nr = "2")
report(results, identifier = "ANOVA", term = "N", statistic = "p")

}
