% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyprompt.R
\name{tidyprompt-class}
\alias{tidyprompt-class}
\title{Tidyprompt R6 Class}
\description{
A \linkS4class{tidyprompt} object contains a base prompt and a list
of \code{\link[=prompt_wrap]{prompt_wrap()}} objects. It provides structured methods to modify the prompt
while simultaneously adding logic to extract from and validate the LLM response.
Besides a base prompt, a \linkS4class{tidyprompt} object may contain a system prompt
and a chat history which precede the base prompt.
}
\examples{
prompt <- tidyprompt("Hi!")
print(prompt)

# Add to a tidyprompt using a prompt wrap:
prompt <- tidyprompt("Hi!") |>
  add_text("How are you?")
print(prompt)

# Strings can be input for prompt wraps; therefore,
#   a call to tidyprompt() is not necessary:
prompt <- "Hi" |>
  add_text("How are you?")

# Example of adding extraction & validation with a prompt_wrap():
prompt <- "Hi" |>
  add_text("What is 5 + 5?") |>
  answer_as_integer()

\dontrun{
  # tidyprompt objects are evaluated by send_prompt(), which will
  #   handle construct the prompt text, send it to the LLM provider,
  #   and apply the extraction and validation functions from the tidyprompt object
  prompt |>
    send_prompt(llm_provider_ollama())
  # --- Sending request to LLM provider (llama3.1:8b): ---
  #   Hi
  #
  #   What is 5 + 5?
  #
  #   You must answer with only an integer (use no other characters).
  # --- Receiving response from LLM provider: ---
  #   10
  # [1] 10

  # See prompt_wrap() and send_prompt() for more details
}

# `tidyprompt` objects may be validated with these helpers:
is_tidyprompt(prompt) # Returns TRUE if input is a valid tidyprompt object

# Get base prompt text
base_prompt <- prompt$base_prompt

# Get all prompt wraps
prompt_wraps <- prompt$get_prompt_wraps()
# Alternative:
prompt_wraps <- get_prompt_wraps(prompt)

# Construct prompt text
prompt_text <- prompt$construct_prompt_text()
# Alternative:
prompt_text <- construct_prompt_text(prompt)

# Set chat history (affecting also the base prompt)
chat_history <- data.frame(
  role = c("user", "assistant", "user"),
  content = c("What is 5 + 5?", "10", "And what is 5 + 6?")
)
prompt$set_chat_history(chat_history)

# Get chat history
chat_history <- prompt$get_chat_history()
}
\seealso{
Other tidyprompt: 
\code{\link{construct_prompt_text}()},
\code{\link{get_chat_history}()},
\code{\link{get_prompt_wraps}()},
\code{\link{is_tidyprompt}()},
\code{\link{set_chat_history}()},
\code{\link{tidyprompt}()}
}
\concept{tidyprompt}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{base_prompt}}{The base prompt string.
The base prompt be modified by prompt wraps during \code{\link[=construct_prompt_text]{construct_prompt_text()}};
the modified prompt text will be used as the final message of role 'user'
during \code{\link[=send_prompt]{send_prompt()}}}

\item{\code{system_prompt}}{A system prompt string.
This will be added at the start of the chat history as role 'system'
during \code{\link[=send_prompt]{send_prompt()}}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Tidyprompt-new}{\code{tidyprompt-class$new()}}
\item \href{#method-Tidyprompt-is_valid}{\code{tidyprompt-class$is_valid()}}
\item \href{#method-Tidyprompt-add_prompt_wrap}{\code{tidyprompt-class$add_prompt_wrap()}}
\item \href{#method-Tidyprompt-get_prompt_wraps}{\code{tidyprompt-class$get_prompt_wraps()}}
\item \href{#method-Tidyprompt-construct_prompt_text}{\code{tidyprompt-class$construct_prompt_text()}}
\item \href{#method-Tidyprompt-set_chat_history}{\code{tidyprompt-class$set_chat_history()}}
\item \href{#method-Tidyprompt-get_chat_history}{\code{tidyprompt-class$get_chat_history()}}
\item \href{#method-Tidyprompt-clone}{\code{tidyprompt-class$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tidyprompt-new"></a>}}
\if{latex}{\out{\hypertarget{method-Tidyprompt-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \linkS4class{tidyprompt} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidyprompt-class$new(input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{A string, a chat history, a list containing
a chat history under key '$chat_history', or a \linkS4class{tidyprompt} object}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Different types of input are accepted for initialization of
a \linkS4class{tidyprompt} object:
\itemize{
\item A single character string. This will be used as the base prompt

\item A dataframe which is a valid chat history (see \code{\link[=chat_history]{chat_history()}})

\item A list containing a valid chat history under '$chat_history'
(e.g., a result from \code{\link[=send_prompt]{send_prompt()}} when using 'return_mode' = "full")

\item A \linkS4class{tidyprompt} object. This will be checked for validity and, if valid,
the fields are copied to the object which is returned from this method
}
When passing a dataframe or list with a chat history, the last row of the
chat history must have role 'user'; this row will be used as the base prompt.
If the first row of the chat history has role 'system', it will be used
as the system prompt.
}

\subsection{Returns}{
A \linkS4class{tidyprompt} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tidyprompt-is_valid"></a>}}
\if{latex}{\out{\hypertarget{method-Tidyprompt-is_valid}{}}}
\subsection{Method \code{is_valid()}}{
Check if the tidyprompt object is valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidyprompt-class$is_valid()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if valid, otherwise \code{FALSE}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tidyprompt-add_prompt_wrap"></a>}}
\if{latex}{\out{\hypertarget{method-Tidyprompt-add_prompt_wrap}{}}}
\subsection{Method \code{add_prompt_wrap()}}{
Add a \code{\link[=prompt_wrap]{prompt_wrap()}} to the \linkS4class{tidyprompt} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidyprompt-class$add_prompt_wrap(prompt_wrap)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt_wrap}}{A \code{\link[=prompt_wrap]{prompt_wrap()}} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated \linkS4class{tidyprompt} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tidyprompt-get_prompt_wraps"></a>}}
\if{latex}{\out{\hypertarget{method-Tidyprompt-get_prompt_wraps}{}}}
\subsection{Method \code{get_prompt_wraps()}}{
Get list of \code{\link[=prompt_wrap]{prompt_wrap()}} objects from the \linkS4class{tidyprompt} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidyprompt-class$get_prompt_wraps(
  order = c("default", "modification", "evaluation")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{order}}{The order to return the wraps. Options are:
\itemize{
\item "default": as originally added to the object
\item "modification": as ordered for modification of the base prompt;
ordered by type: check, unspecified, mode, tool, break. This is the order
in which prompt wraps are applied during \code{\link[=construct_prompt_text]{construct_prompt_text()}}
\item "evaluation": ordered for evaluation of the LLM response;
ordered by type: tool, mode, break, unspecified, check. This is the order
in which wraps are applied to the LLM output during \code{\link[=send_prompt]{send_prompt()}}
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of \code{\link[=prompt_wrap]{prompt_wrap()}} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tidyprompt-construct_prompt_text"></a>}}
\if{latex}{\out{\hypertarget{method-Tidyprompt-construct_prompt_text}{}}}
\subsection{Method \code{construct_prompt_text()}}{
Construct the complete prompt text.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidyprompt-class$construct_prompt_text(llm_provider = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{llm_provider}}{Optional \linkS4class{llm_provider} object.
This may sometimes affect the prompt text construction}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string representing the constructed prompt text
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tidyprompt-set_chat_history"></a>}}
\if{latex}{\out{\hypertarget{method-Tidyprompt-set_chat_history}{}}}
\subsection{Method \code{set_chat_history()}}{
This function sets the chat history for the tidyprompt object.
The chat history will also set the base prompt and system prompt
(the last message of the chat history should be of role 'user' and
will be used as the base prompt; the first message of the chat history
may be of the role 'system' and will then be used as the system prompt).
This may be useful when one wants to change the base prompt, system prompt,
and chat history of a \linkS4class{tidyprompt} object while retaining other fields like
the prompt wraps.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidyprompt-class$set_chat_history(chat_history)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{chat_history}}{A valid chat history (see \code{\link[=chat_history]{chat_history()}})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated \linkS4class{tidyprompt} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tidyprompt-get_chat_history"></a>}}
\if{latex}{\out{\hypertarget{method-Tidyprompt-get_chat_history}{}}}
\subsection{Method \code{get_chat_history()}}{
This function gets the chat history of the \linkS4class{tidyprompt} object.
The chat history is constructed from the base prompt, system prompt, and chat
history field. The returned object will be the chat history
with the system prompt as the first message with role 'system' and the
the base prompt as the last message with role 'user'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidyprompt-class$get_chat_history()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A dataframe containing the chat history
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tidyprompt-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Tidyprompt-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tidyprompt-class$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
