% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_other_extract_from_return_list.R
\name{extract_from_return_list}
\alias{extract_from_return_list}
\title{Function to extract a specific element from a list}
\usage{
extract_from_return_list(list, name_of_element = "response")
}
\arguments{
\item{list}{A list, typically the output from \code{\link[=send_prompt]{send_prompt()}} with \code{return_mode = "full"}}

\item{name_of_element}{A character string with the name of the element to extract from the list}
}
\value{
The extracted element from the list
}
\description{
This function is intended as a helper function for piping with output from
\code{\link[=send_prompt]{send_prompt()}} when using \code{return_mode = "full"}. It allows to
extract a specific element from the list returned by \code{\link[=send_prompt]{send_prompt()}}, which
can be useful for further piping.
}
\examples{
\dontrun{
  response <- "Hi!" |>
    send_prompt(llm_provider_ollama(), return_mode = "full") |>
    extract_from_return_list("response")
  response
  # [1] "It's nice to meet you. Is there something I can help you with,
  # or would you like to chat?"
}
}
\concept{miscellaneous_helpers}
