% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-fit.R
\name{tidypredict_fit}
\alias{tidypredict_fit}
\title{Returns a Tidy Eval formula to calculate fitted values}
\usage{
tidypredict_fit(model)
}
\arguments{
\item{model}{An R model or a tibble with a parsed model. It currently supports
lm(), glm() and randomForest() models.}
}
\description{
It parses a model or uses an already parsed model to return a
Tidy Eval formula that can then be used inside a dplyr command.
}
\examples{

library(dplyr)
df <- mutate(mtcars, cyl = paste0("cyl", cyl))
model <- lm(mpg ~ wt + cyl * disp, offset = am, data = df)
tidypredict_fit(model)

}
