% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace-na-if.R
\name{replace_na_if}
\alias{replace_na_if}
\title{Conditional replacement of NAs with specified values}
\usage{
replace_na_if(x, condition, true)
}
\arguments{
\item{x}{Vector with missing values to modify.}

\item{condition}{Logical vector}

\item{true}{The replacement values where condition is \code{TRUE}.}
}
\value{
A modified version of x that replaces any missing values where condition is \code{TRUE}
with \code{true}.
}
\description{
Unlike \code{\link[tidyr:replace_na]{tidyr::replace_na()}}, it is only defined for vectors.
}
\details{
\code{replace_na_if()} is a wrapper on \code{if_else2(is.na(x) & condition, true, x)}
}
\examples{
data <- tibble::tibble(
  x = c(TRUE, FALSE, NA), 
  y = c("x is false", NA, "x is false"))
  
dplyr::mutate(data,
    x1 = tidyr::replace_na(x, FALSE),
    x3 = if_else2(is.na(x) & y == "x is false", FALSE, x),
    x4 = replace_na_if(x, y == "x is false", FALSE))
}
\seealso{
\code{\link[tidyr:replace_na]{tidyr::replace_na()}} and \code{\link[=if_else2]{if_else2()}}
}
