% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hts_recent.R
\name{hts_recent}
\alias{hts_recent}
\title{Subset Clients who had Recent Infection Test Done during a period of Interest}
\usage{
hts_recent(data, from = NULL, to = NULL, states = NULL, facilities = NULL)
}
\arguments{
\item{data}{An NDR dataframe imported using the \code{read_ndr()}.}

\item{from}{The start date in ISO8601 format (i.e. "yyyy-mm-dd").
The default is to start at the beginning of the current Fiscal Year (i.e. 1st of October).}

\item{to}{The end date written in ISO8601 format (i.e. "yyyy-mm-dd").
The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}
}
\value{
line-list of clients who had recent HIV infection test done during the period of interest
}
\description{
Subset Clients who had Recent Infection Test Done during a period of Interest
}
\examples{
### Line-list of clients offered recency testing
hts_recent_clients <- hts_recent(recency_example, from = "2021-07-01", to = "2021-10-31")

hts_pos <- hts_tst_pos(recency_example) # identifies all hts_positive clients
# line-list positive clients offered recency testing in 'Okun' state
hts_recent(hts_pos, state = "Okun")

}
