% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disaggregate.R
\name{disaggregate}
\alias{disaggregate}
\title{Summarise an indicator into finer details by the specified variable}
\usage{
disaggregate(data, by, level = "state")
}
\arguments{
\item{data}{Data containing the indicator to be disaggregated.}

\item{by}{The variable of interest to be used for the disaggregation. The
options are any of: \code{"sex"}, \code{"current_age"} and \code{"pregnancy_status"}.}

\item{level}{The level at which the disaggregation should be performed.
The options are "ip" (or "country"), "state", "lga" or "facility". The default
value is "state".}
}
\value{
disaggregate
}
\description{
Counts the number of occurrence of an outcome based on the category of
interest. It also provides "Totals" at the end of the columns or rows (or both)
where appropriate.
}
\examples{
### Disaggregate "TX_NEW" clients into age categories for each state
new_clients <- tx_new(ndr_example)
disaggregate(new_clients, by = "current_age") # default value of level is "state"

### Disaggregate "TX_CURR" by gender for each facility
curr_clients <- tx_curr(ndr_example)
disaggregate(curr_clients, by = "sex", level = "facility")
}
