% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyper_tbl_cube.R
\name{hyper_tbl_cube}
\alias{hyper_tbl_cube}
\alias{hyper_tbl_cube.tidync}
\alias{hyper_tbl_cube.character}
\title{A dplyr cube tbl}
\usage{
hyper_tbl_cube(x, ...)

\method{hyper_tbl_cube}{tidync}(x, ...)

\method{hyper_tbl_cube}{character}(x, ...)
}
\arguments{
\item{x}{tidync object}

\item{...}{arguments for \code{\link[=hyper_filter]{hyper_filter()}}}
}
\value{
tbl_cube

\code{dplyr::tbl_cube}
}
\description{
Produce a \link[dplyr:tbl_cube]{tbl_cube} from NetCDF. This is a
delay-breaking function and causes data to be read from the source
into the tbl cube format defined in the \link[dplyr:tbl_cube]{dplyr}
package.
}
\details{
The tbl cube is a very general and arbitrarily-sized array that
can be used with tidyverse functionality. Dimension coordinates are
stored with the tbl cube, derived from the grid
\link[=hyper_transforms]{transforms}.
}
\examples{
f <- "S20080012008031.L3m_MO_CHL_chlor_a_9km.nc"
l3file <- system.file("extdata/oceandata", f, package= "tidync")
(cube <- hyper_tbl_cube(tidync(l3file) \%>\%
activate(chlor_a), lon = lon > 107, lat = abs(lat) < 30))
ufile <- system.file("extdata", "unidata", "test_hgroups.nc", 
 package = "tidync", mustWork = TRUE)
 
## some versions of NetCDF don't support this file
## (4.1.3 tidync/issues/82)
group_nc <- try(tidync(ufile), silent = TRUE)
if (!inherits(group_nc, "try-error")) {
 res <-  hyper_tbl_cube(tidync(ufile))
 print(res)
} else {
 ## the error was
 writeLines(c(group_nc))
}
}
\seealso{
\code{\link[=hyper_array]{hyper_array()}} and \code{\link[=hyper_tibble]{hyper_tibble()}} which are also delay-breaking
functions that cause data to be read
}
