% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/json_types.r
\name{json_types}
\alias{json_types}
\title{Add a column that tells the 'type' of the data in the root of the JSON}
\usage{
json_types(x, column.name = "type")
}
\arguments{
\item{x}{a tbl_json object}

\item{column.name}{the name to specify for the type column}
}
\value{
a tbl_json object with column.name column that tells the type
}
\description{
The function json_types() inspects the JSON associated with
each row of the tbl_json data.frame, and adds a new column ("type" by
default) that identifies the type according to the
JSON standard at http://json.org/.
}
\details{
This is particularly useful for inspecting your JSON data types, and can added
after gather_array() (or gather_keys()) to inspect the types of the elements
(or values) in arrays (or objects).
}
\examples{
library(magrittr)  # for \%>\%
c('{"a": 1}', '[1, 2]', '"a"', '1', 'true', 'null') \%>\% json_types
}

