% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_gam}
\alias{predict_gam}
\title{Get predictions from a GAM model}
\usage{
predict_gam(
  model,
  length_out = 10,
  values = NULL,
  series = NULL,
  exclude_terms = NULL,
  ci_z = 1.96,
  tran_fun = NULL,
  separate = NULL,
  sep_by = "\\\\."
)
}
\arguments{
\item{model}{A \code{gam} or \code{bam} model object.}

\item{length_out}{An integer indicating how many values to use along the
numeric variables for predicting the response (the default is \code{10}).}

\item{values}{User supplied values for specific variables as a named list.}

\item{series}{A string specifying the variable that corresponds to the series
to be plotted on the $x$-axis. If a string is given, the other numeric
variables in the model are set to their mean value, unless specific values
are given in \code{values}. If a character vector of two strings is given, the
two variables will be taken as the elements of a tensor product smooth.
This allows the user to plot 2D raster plots.}

\item{exclude_terms}{Terms to be excluded from the prediction. Term names
should be given as they appear in the model summary (for example,
\code{"s(x0,x1)"}).}

\item{ci_z}{The z-value for calculating the CIs (the default is \code{1.96} for
95 percent CI).}

\item{tran_fun}{Function to use for transforming the predicted values and CIs.}

\item{separate}{Names list of factor interaction variables to be separated.}

\item{sep_by}{Character to separate by (the default is \verb{\\\\.}).}
}
\value{
A tibble with predictions.
}
\description{
Return predictions from a GAM model generated with mgcv. The output can be plotted with \code{plot()}.
}
\examples{
library(mgcv)
set.seed(10)

sim_data_1 <- gamSim(1, n = 200, scale = 2)
model <- gam(y ~ x0 + s(I(x1^2)) + s(x2) + offset(x3), data = sim_data_1)
predict_gam(model)
predict_gam(model, values = list(x0 = mean(sim_data_1$x0)))
predict_gam(model, series = "x2")
predict_gam(model, exclude_terms = "s(I(x1^2))")

# By-variables
sim_data_2 <- gamSim(4)
model_2 <- gam(y ~ s(x2, by = fac) + s(x0), data = sim_data_2)
predict_gam(model_2)

# Poisson data
sim_data_3 <- sim_data_2
sim_data_3$y <- round(sim_data_2$y) + 20
model_3 <- gam(y ~ s(x2, by = fac), data = sim_data_3, family = poisson)
predict_gam(model_3, length_out = 50)
predict_gam(model_3, length_out = 50, tran_fun = exp)

# Bivariate smooths
model_4 <- gam(y ~ te(x1, x2), data = sim_data_1)
predict_gam(model_4)
}
