% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice}
\alias{slice}
\alias{slice_head}
\alias{slice_tail}
\alias{slice_max}
\alias{slice_min}
\alias{slice_sample}
\title{Subset rows using their positions}
\usage{
slice(.data, ...)

slice_head(.data, n)

slice_tail(.data, n)

slice_max(.data, order_by, n, with_ties = TRUE)

slice_min(.data, order_by, n, with_ties = TRUE)

slice_sample(.data, n, replace = FALSE)
}
\arguments{
\item{.data}{A data.table}

\item{...}{Provide either positive values to keep, or negative values to drop.
The values provided must be either all positive or all negative.}

\item{n}{When larger than or equal to 1, the number of rows.
When between 0 and 1, the proportion of rows to select.}

\item{order_by}{Variable or function of variables to order by.}

\item{with_ties}{Should ties be kept together? The default, `TRUE`,
may return more rows than you request. Use `FALSE` to ignore ties,
and return the first `n` rows.}

\item{replace}{Should sampling be performed with (`TRUE`) or without
(`FALSE`, the default) replacement.}
}
\value{
A data.table
}
\description{
`slice()` lets you index rows by their (integer) locations. It allows you
to select, remove, and duplicate rows. It is accompanied by a number of
helpers for common use cases:

* `slice_head()` and `slice_tail()` select the first or last rows.
* `slice_sample()` randomly selects rows.
* `slice_min()` and `slice_max()` select rows with highest or lowest values
  of a variable.
}
\examples{

a = as.data.table(iris)
slice(a,1,2)
slice(a,2:3)
slice_head(a,5)
slice_head(a,0.1)
slice_tail(a,5)
slice_tail(a,0.1)
slice_max(a,Sepal.Length,10)
slice_max(a,Sepal.Length,10,with_ties = FALSE)
slice_min(a,Sepal.Length,10)
slice_min(a,Sepal.Length,10,with_ties = FALSE)
slice_sample(a,10)
slice_sample(a,0.1)

}
\seealso{
\code{\link[dplyr]{slice}}
}
