% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.quantile_rf.R
\name{.fit.quantile_rf}
\alias{.fit.quantile_rf}
\title{Quantile regression forest for \code{tidyfit}}
\usage{
\method{.fit}{quantile_rf}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a nonlinear quantile regression forest on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}
\itemize{
\item ntree (\emph{number of trees})
\item mtry (\emph{number of variables randomly sampled at each split})
}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item \code{tau} (the quantile(s) to be estimated)
}

The function provides a wrapper for \code{quantregForest::quantregForest}. See \code{?quantregForest} for more details.
The argument \code{tau} is the chosen quantile (default \code{tau = 0.5}).
\code{tau} is passed directly to \code{m('quantile_rf', tau = c(0.1, 0.5, 0.9)} and is not passed to \code{predict} as in the \code{quantregForest::quantregForest} package. This is done to ensure a consistent interface with the quantile regression from \code{quantreg}.

\strong{Implementation}

\emph{No implementation notes}
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data <- dplyr::filter(data, Industry == "HiTec")
data <- dplyr::select(data, -Date, -Industry)

# Stand-alone function
fit <- m("quantile_rf", Return ~ ., data, tau = 0.5, ntree = 50)
fit

# Within 'regress' function
fit <- regress(data, Return ~ .,
               m("quantile_rf", tau = c(0.1, 0.5, 0.9), ntree = 50))
explain(fit)

}
\references{
Meinshausen N (2017). \emph{quantregForest: Quantile Regression Forests}. R package version 1.3-7, \url{https://CRAN.R-project.org/package=quantregForest}.
}
\seealso{
\code{\link{.fit.quantile}}, \code{\link{.fit.rf}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
