% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data_wrds_fisd}
\alias{download_data_wrds_fisd}
\title{Download Filtered FISD Data from WRDS}
\usage{
download_data_wrds_fisd()
}
\value{
A data frame containing a subset of FISD data with fields related to
the bond's characteristics and issuer information. This includes complete
CUSIP, maturity, offering amount, offering date, dated date, interest
frequency, coupon, last interest date, issue ID, issuer ID, SIC code of the
issuer.
}
\description{
Establishes a connection to the WRDS database to download a filtered subset
of the FISD (Fixed Income Securities Database). The function filters the
\code{fisd_mergedissue} and \code{fisd_mergedissuer} tables based on several criteria
related to the securities, such as security level, bond type, coupon type,
and others, focusing on specific attributes that denote the nature of the
securities. It finally returns a data frame with selected fields from the
\code{fisd_mergedissue} table after joining it with issuer information from the
\code{fisd_mergedissuer} table for issuers domiciled in the USA.
}
\examples{
\donttest{
  fisd <- download_data_wrds_fisd()
}

}
