% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_countries_by_region}
\alias{get_countries_by_region}
\title{get_countries_by_region}
\usage{
get_countries_by_region(country_region_value)
}
\arguments{
\item{country_region_value}{A character string representing the region, subregion, or continent. The input is case-insensitive.}
}
\value{
A data frame containing the list of countries within the specified region, subregion, or continent, ordered alphabetically by country name.
If no match is found, a warning message is displayed, and a list of all available regions, subregions, and continents is provided.
}
\description{
This function retrieves a list of countries based on a specified region, subregion, or continent.
The function is case-insensitive and orders the countries alphabetically by their common names.
If the input does not match any region, subregion, or continent, the function provides a list of all available regions, subregions, and continents.
}
\note{
The function utilizes the pre-loaded \code{restcountries_data} dataset. Ensure that this dataset is loaded before invoking the function.
The selected columns include country codes, names, capital, region, subregion, start of the week, car side, currencies, population, latitude, and longitude.
}
\examples{
\donttest{
# Example usage: Get a list of countries in Africa
africa_countries <- get_countries_by_region("Africa")
print(africa_countries)

# Example usage: Get a list of countries in Western Europe (a subregion)
western_europe_countries <- get_countries_by_region("Western Europe")
print(western_europe_countries)

# Example usage: Get a list of countries in the continent of Asia
asia_countries <- get_countries_by_region("Asia")
print(asia_countries)
}

}
