% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_regex.R
\name{factor_regex}
\alias{factor_regex}
\title{Generate Regular Expression to Detect Factors}
\usage{
factor_regex(m, at_start = TRUE)
}
\arguments{
\item{m}{A model object, created using a function such as \link[stats:lm]{stats::lm()}}

\item{at_start}{Logical indicating whether or not to include `^` in the regular expression to begin search at start of string}
}
\value{
A character string for use a regular expression.
}
\description{
Primarily developed for use within \link[tidycat:tidy_categorical]{tidycat::tidy_categorical()}
}
\examples{
m0 <- lm(formula = mpg ~ disp + as.factor(am)*as.factor(vs), data = mtcars)
factor_regex(m = m0)
}
