% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_lineribbon.R
\name{geom_lineribbon}
\alias{geom_lineribbon}
\title{Line + multiple probability ribbon plots (ggplot geom)}
\usage{
geom_lineribbon(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
A combination of \code{\link[=geom_line]{geom_line()}} and \code{\link[=geom_ribbon]{geom_ribbon()}} with default aesthetics
designed for use with output from \code{\link[=point_interval]{point_interval()}}.
}
\details{
\code{geom_lineribbon} is a combination version of a \code{\link[=geom_line]{geom_line()}}, and \code{geom_ribbon} designed for use
with output from \code{\link[=point_interval]{point_interval()}}. This geom sets some default aesthetics equal to the \code{.lower},
\code{.upper}, and \code{.width} columns generated by the \code{point_interval} family of functions, making them
often more convenient than a vanilla \code{\link[=geom_ribbon]{geom_ribbon()}} + \code{\link[=geom_line]{geom_line()}}.

Specifically, \code{geom_lineribbon} acts as if its default aesthetics are
\code{aes(ymin = .lower, ymax = .upper, forcats::fct_rev(ordered(.width)))}.
}
\examples{

library(dplyr)
library(ggplot2)

tibble(x = 1:10) \%>\%
  group_by_all() \%>\%
  do(tibble(y = rnorm(100, .$x))) \%>\%
  median_qi(.width = c(.5, .8, .95)) \%>\%
  ggplot(aes(x = x, y = y)) +
  # automatically uses aes(ymin = .lower, ymax = .upper, fill = fct_rev(ordered(.width)))
  geom_lineribbon() +
  scale_fill_brewer()

}
\seealso{
See \code{\link[=stat_lineribbon]{stat_lineribbon()}} for a version that does summarizing of samples into points and intervals
within ggplot. See \code{\link[=geom_pointinterval]{geom_pointinterval()}} / \code{\link[=geom_pointintervalh]{geom_pointintervalh()}} for a similar geom intended
for point summaries and intervals. See \code{\link[=geom_ribbon]{geom_ribbon()}} and \code{\link[=geom_line]{geom_line()}} for the geoms this is
based on.
}
\author{
Matthew Kay
}
