% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openmx_functions.R
\name{lsub}
\alias{lsub}
\title{Apply pattern replacement over a vector}
\usage{
lsub(x, replacement = NULL, pattern = "{C}", fixed = TRUE, ...)
}
\arguments{
\item{x}{A character vector where matches are sought.}

\item{replacement}{a character vector of length 1 or more. Each element is
applied to \code{x} in turn. Default: NULL}

\item{pattern}{A character string containing a regular expression (or
character string when \code{fixed = TRUE}). Default: \code{'{C}'}.}

\item{fixed}{logical. If TRUE, pattern is a string to be matched as is.
Default: TRUE}

\item{...}{Parameters passed on to \code{\link[base:grep]{gsub}}.}
}
\value{
A list of results returned by \code{\link[base:grep]{gsub}}.
}
\description{
\code{lsub} returns a list of the same length as
\code{replacement}, each element of which is the result of applying
\code{\link[base:grep]{gsub}} to \code{x} using \code{\link{lapply}}.
}
\examples{
lsub("a{C}", 1:3)
}
