% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_PERMANOVA.R
\name{micro_PERMANOVA}
\alias{micro_PERMANOVA}
\title{A function to run PERMANOVA on tidi_micro data sets}
\usage{
micro_PERMANOVA(micro_set, beta_div, method, ..., nperm = 999)
}
\arguments{
\item{micro_set}{A tidy_micro data set}

\item{beta_div}{A dissimilarity matrix calculated by \code{beta_div}}

\item{method}{A character string indicating the method used to calculated dissimilarity}

\item{...}{Covariates of interest}

\item{nperm}{Number of permutations}
}
\description{
A wrapper function to call \code{\link[vegan]{adonis2}} from the \code{vegan} package. PERMANOVA is a method for partitioning distance matrices among sources of variation and fitting linear models (e.g., factors, polynomial regression) to distance matrices; uses a permutation test with pseudo-F ratios
}
\details{
The function adonis2 is based on the principles of McArdle & Anderson (2001) and can perform sequential, marginal and overall tests. Function adonis2 also allows using additive constants or squareroot of dissimilarities to avoid negative eigenvalues
}
\examples{
data(phy); data(cla); data(ord); data(fam); data(clin)
otu_tabs = list(Phylum = phy, Class = cla, Order = ord, Family = fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = clin) \%>\%
filter(day == 7) ## Only including the first week

## Bray-Curtis beta diversity
bray <- set \%>\% beta_div(table = "Family")

set \%>\% micro_PERMANOVA(bray, method = "bray", bpd1)
}
\references{
\code{\link[vegan]{vegdist}} \code{\link[vegan]{adonis2}}
}
\seealso{
\code{\link[vegan]{adonis}}
}
