% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-classification-fast.R
\name{fast_classification}
\alias{fast_classification}
\title{Generate Model Specification calls to \code{parsnip}}
\usage{
fast_classification(
  .data,
  .rec_obj,
  .parsnip_fns = "all",
  .parsnip_eng = "all",
  .split_type = "initial_split",
  .split_args = NULL
)
}
\arguments{
\item{.data}{The data being passed to the function for the classification problem}

\item{.rec_obj}{The recipe object being passed.}

\item{.parsnip_fns}{The default is 'all' which will create all possible
classification model specifications supported.}

\item{.parsnip_eng}{the default is 'all' which will create all possible
classification model specifications supported.}

\item{.split_type}{The default is 'initial_split', you can pass any type of
split supported by \code{rsample}}

\item{.split_args}{The default is NULL, when NULL then the default parameters
of the split type will be executed for the rsample split type.}
}
\value{
A list or a tibble.
}
\description{
Creates a list/tibble of parsnip model specifications.
}
\details{
With this function you can generate a tibble output of any classification
model specification and it's fitted \code{workflow} object. Per recipes documentation
explicitly with \code{step_string2factor()} it is encouraged to mutate your predictor
into a factor before you create your recipe.
}
\examples{
library(recipes, quietly = TRUE)
library(dplyr, quietly = TRUE)

df <- mtcars \%>\% mutate(cyl = as.factor(cyl))
rec_obj <- recipe(cyl ~ ., data = df)

fct_tbl <- fast_classification(
  .data = df,
  .rec_obj = rec_obj,
  .parsnip_eng = c("glm","LiblineaR"))

glimpse(fct_tbl)

}
\seealso{
Other Model_Generator: 
\code{\link{create_model_spec}()},
\code{\link{fast_regression}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Model_Generator}
