% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threeBrain.R
\name{threeBrain}
\alias{threeBrain}
\title{Create a brain object}
\usage{
threeBrain(
  path,
  subject_code,
  surface_types = "pial",
  atlas_types = "aparc+aseg",
  ...,
  template_subject = unname(getOption("threeBrain.template_subject", "N27"))
)
}
\arguments{
\item{path}{path to 'FreeSurfer' directory, or 'RAVE' subject directory
containing 'FreeSurfer' files, or simply a 'RAVE' subject}

\item{subject_code}{subject code, characters}

\item{surface_types}{surface types to load; default is \code{'pial'},
other common types are \code{'white'}, \code{'smoothwm'}}

\item{atlas_types}{brain atlas to load; default is \code{'aparc+aseg'},
other choices are \code{'aparc.a2009s+aseg'}, \code{'aparc.DKTatlas+aseg'},
depending on the atlas files in \code{'fs/mri'} folder}

\item{...}{reserved for future use}

\item{template_subject}{template subject to refer to; used for group
template mapping}
}
\description{
Create a brain object
}
