% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threejs_brain.R
\name{threejs_brain}
\alias{threejs_brain}
\title{Create a Threejs Brain and View it in Browsers}
\usage{
threejs_brain(
  ...,
  .list = list(),
  width = NULL,
  height = NULL,
  background = "#FFFFFF",
  cex = 1,
  timestamp = TRUE,
  side_canvas = FALSE,
  side_zoom = 1,
  side_width = 250,
  side_shift = c(0, 0),
  side_display = TRUE,
  control_panel = TRUE,
  control_presets = NULL,
  control_display = TRUE,
  camera_center = c(0, 0, 0),
  camera_pos = c(500, 0, 0),
  start_zoom = 1,
  coords = NULL,
  symmetric = 0,
  default_colormap = "Value",
  palettes = NULL,
  value_ranges = NULL,
  value_alias = NULL,
  show_inactive_electrodes = TRUE,
  widget_id = "threebrain_data",
  tmp_dirname = NULL,
  debug = FALSE,
  token = NULL,
  controllers = list(),
  browser_external = TRUE,
  global_data = list(),
  global_files = list()
)
}
\arguments{
\item{..., .list}{geometries inherit from AbstractGeom}

\item{width, height}{positive integers. Width and height of the widget.
By default width=`100\%`, and height varies.}

\item{background}{character, background color such as \code{"#FFFFFF"} or \code{"white"}}

\item{cex}{positive number, relative text magnification level}

\item{timestamp}{logical, whether to show timestamp at the beginning}

\item{side_canvas}{logical, enable side cameras to view objects from fixed perspective}

\item{side_zoom}{numerical, if side camera is enabled, zoom-in level, from 1 to 5}

\item{side_width}{positive integer, side panel size in pixels}

\item{side_shift}{integer of length two, side panel shift in pixels (`CSS style`: top, left)}

\item{side_display}{logical, show/hide side panels at beginning}

\item{control_panel}{logical, enable control panels for the widget}

\item{control_presets}{characters, presets to be shown in control panels}

\item{control_display}{logical, whether to expand/collapse control UI at the beginning}

\item{camera_center}{numerical, length of three, XYZ position where camera should focus at}

\item{camera_pos}{XYZ position of camera itself, default (0, 0, 500)}

\item{start_zoom}{numerical, positive number indicating camera zoom level}

\item{coords}{\code{NULL} to hide coordinates or numeric vector of three.}

\item{symmetric}{numerical, default 0, color center will be mapped to this value}

\item{default_colormap}{character, which color map name to display at startup}

\item{palettes}{named list, names corresponds to color-map names if you want to change color palettes}

\item{value_ranges}{named list, similar to \code{palettes}, value range for each values}

\item{value_alias}{named list, legend title for corresponding variable}

\item{show_inactive_electrodes}{logical, whether to show electrodes with no values}

\item{widget_id}{character, internally used as unique identifiers for widgets.
Only use it when you have multiple widgets in one website}

\item{tmp_dirname}{character path, internally used, where to store temporary files}

\item{debug}{logical, internally used for debugging}

\item{token}{unique character, internally used to identify widgets in JS localStorage}

\item{controllers}{list to override the settings, for example \code{proxy$get_controllers()}}

\item{browser_external}{logical, use system default browser (default) or builtin one.}

\item{global_data, global_files}{internally use, mainly to store orientation matrices and files.}
}
\description{
Create a Threejs Brain and View it in Browsers
}
\author{
Zhengjia Wang
}
