% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thief.R
\name{thief}
\alias{thief}
\title{Temporal hierarchical forecasting}
\usage{
thief(y, m = frequency(y), h = m * 2, comb = c("struc", "mse", "ols",
  "bu", "shr", "sam"), usemodel = c("ets", "arima", "theta", "naive",
  "snaive"), forecastfunction = NULL, ...)
}
\arguments{
\item{y}{Time series input}

\item{m}{Seasonal period}

\item{h}{Forecast horizon}

\item{comb}{Combination method of temporal hierarchies, taking one of the following values:
\describe{
  \item{"struc"}{Structural scaling - weights from temporal hierarchy}
  \item{"mse"}{Variance scaling - weights from in-sample MSE}
  \item{"ols"}{Unscaled OLS combination weights}
  \item{"bu"}{Bottom-up combination -- i.e., all aggregate forecasts are ignored.}
  \item{"shr"}{GLS using a shrinkage (to block diagonal) estimate of residuals}
  \item{"sam"}{GLS using sample covariance matrix of residuals}
}}

\item{usemodel}{Model used for forecasting each aggregation level:
\describe{
  \item{"ets"}{exponential smoothing, using the \code{\link[forecast]{ets}} function.}
  \item{"arima"}{arima, using the \code{\link[forecast]{auto.arima}} function.}
  \item{"theta"}{theta method, using the \code{\link[forecTheta]{stm}} function.}
  \item{"naive"}{random walk forecasts}
  \item{"snaive"}{seasonal naive forecasts, based on the last year of observed data.}
}}

\item{forecastfunction}{User-defined function to be used instead of \code{usemodel}. The
function must take a time series as the first argument, and the forecast horizon 
as the second argument. It must return an object of class \code{forecast}.}

\item{...}{Arguments to be passed to the time series modelling function 
(such as \code{ets} or \code{auto.arima}), or to \code{forecastfunction}.}
}
\value{
forecast object.
}
\description{
Takes a time series as input and produces forecasts using
the temporal hierarchical approach of Athanasopoulos et al (2016).
}
\details{
This function computes the temporal aggregates of \code{y} using 
\code{\link{tsaggregates}}, then calculates all forecasts using the model function 
specified by \code{usemodel} or \code{forecastfunction}, and finally reconciles the 
forecasts using \code{\link{reconcilethief}}. The reconciled forecasts of \code{y} 
are returned.
}
\examples{
\dontrun{

# Select ARIMA models for all series using auto.arima()
z <- thief(AEdemand[,12], usemodel='arima')
plot(z)

# Use your own function
ftbats <- function(y,h,...){forecast(tbats(y),h)}
z <- thief(AEdemand[,12], forecastfunction=ftbats)
plot(z)
}

}
\author{
Rob J Hyndman and Nikolaos Kourentzes
}
\seealso{
\code{\link{reconcilethief}}
}

