% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TheiaQuery.R
\name{TheiaQuery}
\alias{TheiaQuery}
\title{A query to the Theia website}
\description{
Generate an send a query to Theia web API to get and download tiles based on
input given by the user.
}
\section{Usage}{

\preformatted{
   q <- TheiaQuery$new(query)

   q$update_token()
   q$submit()
}
}

\section{Arguments}{


\describe{
   \item{q:}{A \code{TheiaQuery} object}
   \item{query:}{\code{list}, the users' request, see `Queries` for
   more informations}
}
}

\section{Details}{

   \code{TheiaQuery$new()} Create a new instance of the class, parse `query`
   list and submit the query to Theia to retrieve files catalog

   \code{q$submit()} Submit the query to Theia and get a list of tiles
   corresponding to search criteria
}

\section{Queries}{


   Search criteria are given with a `list` accepting these fields:
   \itemize{
     \item{collection:} The collection to look for. Accepted values are:
       'SENTINEL2', 'Landsat', 'SpotWorldHeritage', 'Snow'. Defaults to
       'SENTINEL2'
     \item{platform:} The platform to look for. Accepted values are:
       'LANDSAT5', 'LANDSAT7', 'LANDSAT8', 'SPOT1', 'SPOT2', 'SPOT3',
       'SPOT4', 'SPOT5', 'SENTINEL2A', 'SENTINEL2B'
     \item{level:} Processing level. Accepted values are: 'LEVEL1C',
       'LEVEL2A', LEVEL3A'. Defaults to 'LEVEL2A'
     \item{town:} The location to look for. Give a common town name.
     \item{tile:} The tile identifier to retrieve.
     \item{start.date:} The first date to look for (format: YYYY-MM-DD).
     \item{end.date:} The last date to look for (format: YYYY-MM-DD).
     \item{latitude:} The x coordinate of a point
     \item{longitude:} The y coordinate of a point
     \item{latmin:} The minimum latitude to search
     \item{latmax:} The maximum latitude to search
     \item{lonmin:} The minimum longitude to search
     \item{lonmax:} The maximum longitude to search
     \item{orbit.number:} The orbit number
     \item{rel.orbit.number:} The relative orbit number
     \item{max.clouds:} The maximum of cloud cover wanted (0-100)
     \item{max.records:} The maximum of tiles to search
   }
}

\examples{

\donttest{
# Create a query to Theia database, looking for tiles from Sentinel2
# satellite around Grenoble, between 2018-07-01 and 2018-07-06.

query <- list(collection = "SENTINEL2",
              town       = "Grenoble",
              start.date = "2018-07-01",
              end.date   = "2018-07-06")
q <- TheiaQuery$new(query)

# Show informations on found tiles
print(q$tiles)
}

}
\seealso{
\url{https://github.com/olivierhagolle/theia_download} for an alternative
   download method based on Python. Inspiration for this function.
}
