% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{tf_smooth}
\alias{tf_smooth}
\alias{tf_smooth.tfb}
\alias{tf_smooth.tfd}
\title{Simple smoothing of \code{tf} objects}
\usage{
tf_smooth(x, ...)

\method{tf_smooth}{tfb}(x, verbose = TRUE, ...)

\method{tf_smooth}{tfd}(
  x,
  method = c("lowess", "rollmean", "rollmedian", "savgol"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{tf} object containing functional data}

\item{...}{arguments for the respective \code{method}. See Details.}

\item{verbose}{give lots of diagnostic messages? Defaults to TRUE}

\item{method}{one of "lowess" (see \code{\link[stats:lowess]{stats::lowess()}}), "rollmean",
"rollmedian" (see \code{\link[zoo:rollmean]{zoo::rollmean()}}) or "savgol" (see \code{\link[pracma:savgol]{pracma::savgol()}})}
}
\value{
a smoothed version of the input. For some methods/options, the
smoothed functions may be shorter than the original ones (at both ends).
}
\description{
Apply running means or medians, \code{lowess} or Savitzky-Golay
filtering to smooth functional data. This does nothing for \code{tfb}-objects,
which should be smoothed by using a smaller basis / stronger penalty.
}
\details{
\code{tf_smooth.tfd} overrides/automatically sets some defaults of the
used methods:
\itemize{
\item \strong{\code{lowess}} uses a span parameter of \code{f} = 0.15 (instead of 0.75)
by default.
\item \strong{\code{rollmean}/\code{median}} use a window size of \code{k} = $<$number of
grid points$>$/20 (i.e., the nearest odd integer to that) and sets \code{fill=   "extend"} (i.e., constant extrapolation to replace missing values at the
extremes of the domain) by default. Use \code{fill= NA} for \code{zoo}'s default
behavior of shortening the smoothed series.
\item \strong{\code{savgol}} uses a window size of \code{k} = $<$number of
grid points$>$/10 (i.e., the nearest odd integer to that).
}
}
\examples{
library(zoo)
library(pracma)
f <- tf_sparsify(tf_jiggle(tf_rgp(4, 201, nugget = 0.05)))
f_lowess <- tf_smooth(f, "lowess")
# these methods ignore the distances between arg-values:
f_mean <- tf_smooth(f, "rollmean")
f_median <- tf_smooth(f, "rollmean", k = 31)
f_sg <- tf_smooth(f, "savgol", fl = 31)
layout(t(1:4))
plot(f, points = FALSE, main = "original")
plot(f_lowess,
  points = FALSE, col = "blue", main = "lowess (default,\n span 0.9 in red)"
)
lines(tf_smooth(f, "lowess", f = 0.9), col = "red", alpha = 0.2)
plot(f_mean,
  points = FALSE, col = "blue", main = "rolling means &\n medians (red)"
)
lines(f_median, col = "red", alpha = 0.2) # note constant extrapolation at both ends!
plot(f, points = FALSE, main = "orginal and\n savgol (red)")
lines(f_sg, col = "red")
}
\concept{tidyfun nonparametric smoothers}
