% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_odt.R
\name{read_odt}
\alias{read_odt}
\title{Read in .odt Content}
\usage{
read_odt(file, skip = 0, remove.empty = TRUE, trim = TRUE, ...)
}
\arguments{
\item{file}{The path to the .odt file.}

\item{skip}{The number of lines to skip.}

\item{remove.empty}{logical.  If \code{TRUE} empty elements in the vector are
removed.}

\item{trim}{logical.  If \code{TRUE} the leading/training white space is
removed.}

\item{...}{ignored.}
}
\value{
Returns a character vector.
}
\description{
Read in the content from a .odt file.
}
\examples{
\dontrun{
url <- "https://github.com/trinker/textreadr/raw/master/inst/docs/Hello_World.odt"
file <- download(url)
(txt <- read_odt(file))
}
}
\keyword{odt}
