% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetVocabFromDtm.R
\name{GetVocabFromDtm}
\alias{GetVocabFromDtm}
\title{Reconstruct a \code{text2vec::vocabulary} object from a document term matrix.}
\usage{
GetVocabFromDtm(dtm)
}
\arguments{
\item{dtm}{A document term matrix of class \code{dgCMatrix}}
}
\value{
Returns a \code{text2vec::vocabulary} object. 
See \code{\link[text2vec]{create_vocabulary}} for more details.
}
\description{
Reconstructs a \code{text2vec::vocabulary} object from a document 
term matrix. See \code{\link[text2vec]{create_vocabulary}} for more details.
}
\examples{
# Load a pre-formatted dtm 
data(nih_sample_dtm) 

vocab <- GetVocabFromDtm(dtm = nih_sample_dtm)

str(vocab)
}
