% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egp3RangeFit.R
\name{egp3RangeFit}
\alias{egp3RangeFit}
\alias{print.egp3RangeFit}
\alias{plot.egp3RangeFit}
\alias{ggplot.egp3RangeFit}
\title{Estimate the EGP3 distribution power parameter over a range of thresholds}
\usage{
egp3RangeFit(data, umin=quantile(data, .05), umax=quantile(data,
.95), nint = 10, penalty = "gaussian", priorParameters = NULL, alpha=0.05)
\method{print}{egp3RangeFit}(x, ...)
\method{plot}{egp3RangeFit}(x, xlab = "Threshold", ylab = "kappa", main = NULL, addNexcesses=TRUE, log.="", ...)
\method{ggplot}{egp3RangeFit}(data, mapping, xlab = "Threshold", ylab = expression(kappa), 
main=NULL,fill="orange", col="blue",addNexcesses=TRUE, textsize=4, ..., environment)
}
\arguments{
\item{data}{The data vector to be modelled.}

\item{umin}{The minimum threshold above which to estimate the parameters.}

\item{umax}{The maximum threshold above which to estimate the parameters.}

\item{nint}{The number of thresholds at which to perform the estimation.}

\item{penalty}{The type of penalty to be used in the maximum penalized
likelihood estimation. Should be either "gaussian" or "none". Defaults to
"gaussian".}

\item{priorParameters}{Parameters to be used for the penalty function.  See
the help for \code{\link{evm}} for more informaiton.}

\item{alpha}{100(1 - alpha)\% confidence intervals will be plotted with the
point estimates. Defaults to \code{alpha = 0.05}.}

\item{x}{Argument to the \code{print} functions.}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{main}{The main title.}

\item{textsize}{Size of text for annotation showing number of threshold excesses.}

\item{addNexcesses}{Annotate top axis with numbers of threshold excesses
arising with the corresponding values of threshold on the bottom axis.}

\item{log.}{Argument passed through to \code{plot}. Can take values "x" for
plotting the x-axis on the log scale, "y" for plotting the y-axis on the log
scale, "xy" for both, or "" (the default) for neither.}

\item{mapping, fill, col, environment}{Arguments to ggplot method.}

\item{\dots}{Arguments to \code{plot}.}
}
\description{
Estimate extended generalized Pareto distribution power parameter over a
range of values, using maximum (penalized) likelihood.
}
\details{
Papastathopoulos and Tawn present 3 extended versions of the generalized
Pareto distribution. Using the \code{egp3} texmex family object, the power
parameter in the EGP3 distribution is estimated on the log scale, a
confidence interval is calculated and the result is transformed back to the
scale of the power parameter and returned to the user.

When the power paramer, kappa, is equal to 1, the EPG3 distribution is
identical to the generalized Pareto distribution. Therefore, the plot of the
estimated parameter over a range of thresholds provides a diagnostic for
threshold selection: the lowest value of kappa whose confidence interval
includes 1 is suggested as the threshold for generalized Pareto modelling.

If lower thresholds are used and the EGP3 distribution itself is used for
modelling, some care should be taken to ensure the model provides a
reasonable degree of fit to the data. Limited experience suggests that such
models seldom fit well and the main value of the EGP3 distribution is as a
diagnostic for threshold selection as described here.

Note this function does not extend to assessing model fit when there are
covariates included in the model.
}
\examples{

erf <- egp3RangeFit(rain)
plot(erf)
ggplot(erf)

}
\references{
I. Papastathopoulos and J. A. Tawn, Extended generalized Pareto
modles for tail estimation, Journal of Statistical Planning and Inference,
143, 131 -- 143, 2013
}
\seealso{
\code{\link{evm}}, \code{\link{gpdRangeFit}}, \code{\link{mrl}}
}
\author{
Harry Southworth
}
\keyword{models}
