% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-directory.R
\name{test_dir}
\alias{test_dir}
\alias{test_package}
\alias{test_check}
\alias{is_testing}
\alias{testing_package}
\title{Run all tests in directory or package}
\usage{
test_dir(
  path,
  filter = NULL,
  reporter = default_reporter(),
  env = test_env(),
  ...,
  encoding = "unknown",
  load_helpers = TRUE,
  stop_on_failure = FALSE,
  stop_on_warning = FALSE,
  wrap = TRUE
)

test_package(
  package,
  filter = NULL,
  reporter = check_reporter(),
  ...,
  stop_on_failure = TRUE,
  stop_on_warning = FALSE
)

test_check(
  package,
  filter = NULL,
  reporter = check_reporter(),
  ...,
  stop_on_failure = TRUE,
  stop_on_warning = FALSE,
  wrap = TRUE
)

is_testing()

testing_package()
}
\arguments{
\item{path}{Path to directory containing tests.}

\item{filter}{If not \code{NULL}, only tests with file names matching this
regular expression will be executed. Matching be performed on the file
name after it has been stripped of \code{"test-"} and \code{".R"}.}

\item{reporter}{Reporter to use to summarise output. Can be supplied
as a string (e.g. "summary") or as an R6 object
(e.g. \code{SummaryReporter$new()}).

See \link{Reporter} for more details and a list of built-in reporters.}

\item{env}{Environment in which to execute the tests. Expert use only.}

\item{...}{Additional arguments passed to \code{\link[=grepl]{grepl()}} to control filtering.}

\item{encoding}{Deprecated. All files now assumed to be UTF-8.}

\item{load_helpers}{Source helper files before running the tests?
See \code{\link[=source_test_helpers]{source_test_helpers()}} for more details.}

\item{stop_on_failure}{If \code{TRUE}, throw an error if any tests fail.

For historical reasons, the default value of \code{stop_on_failure} is \code{TRUE}
for  \code{test_package()} and \code{test_check()} but \code{FALSE} for \code{test_dir()}, so
if you're calling \code{test_dir()} you may want to consider explicitly setting
\code{stop_on_failure = TRUE}.}

\item{stop_on_warning}{If \code{TRUE}, throw an error if any tests generate
warnings.}

\item{wrap}{Automatically wrap all code within \code{\link[=test_that]{test_that()}}? This ensures
that all expectations are reported, even if outside a test block.}

\item{package}{Name of installed package.}
}
\value{
A list of test results.
}
\description{
Use \code{test_dir()} for a collection of tests in a directory; use
\code{test_package()} interactively at the console, and \code{test_check()}
inside of \verb{R CMD check}.

In your own code, you can use \code{is_testing()} to determine if code is being
run as part of a test and \code{testing_package()} to retrieve the name of the
package being tested. You can also check the underlying env var directly
\code{identical(Sys.getenv("TESTTHAT"), "true")} to avoid creating a run-time
dependency on testthat.
}
\section{Test files}{

For package code, tests should live in \code{tests/testthat}.

There are four classes of \code{.R} files that have special behaviour:
\itemize{
\item Test files start with \code{test} and are executed in alphabetical order.
\item Helper files start with \code{helper} and are executed before tests are
run and from \code{devtools::load_all()}.
\item Setup files start with \code{setup} and are executed before tests, but not
during \code{devtools::load_all()}.
\item Teardown files start with \code{teardown} and are executed after the tests
are run.
}
}

\section{Environments}{

Each test is run in a clean environment to keep tests as isolated as
possible. For package tests, that environment that inherits from the
package's namespace environment, so that tests can access internal functions
and objects.
}

\section{\verb{R CMD check}}{

To run testthat automatically from \verb{R CMD check}, make sure you have
a \code{tests/testthat.R} that contains:\preformatted{library(testthat)
library(yourpackage)

test_check("yourpackage")
}
}

\examples{
test_dir(testthat_examples(), reporter = "summary")
test_dir(testthat_examples(), reporter = "minimal")
}
