% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testcorr.R
\name{iid.test}
\alias{iid.test}
\title{Testing iid property}
\usage{
iid.test(x, max.lag, alpha = 0.05, plot = TRUE, table = TRUE,
         var.name = NULL, scale.font = 1)
}
\arguments{
\item{x}{A numeric vector or a univariate numeric time series object or a data frame.}

\item{max.lag}{Maximum lag at which to calculate the test statistics.}

\item{alpha}{Significance level for hypothesis testing used in the plots. Default is 0.05.}

\item{plot}{Logical. If TRUE the test statistics and their critical values are plotted. Default is TRUE.}

\item{table}{Logical. If TRUE the test statistics and their p-values are printed out. Default is TRUE.}

\item{var.name}{NULL or a character string specifying the variable name. If NULL and x has name, the name of x is used. If NULL and x has no name, the string "x" is used. Default is NULL.}

\item{scale.font}{A positive number indicating the scaling of the font size in the plots. Default is 1.}
}
\value{
An object of class "iid.test", which is a list with the following components:
\item{lag}{The lags used.}
\item{jab}{The \eqn{J_{x,|x|}}{J[x,|x|]} test statistics.}
\item{pvjab}{The p-values for the \eqn{J_{x,|x|}}{J[x,|x|]} test statistics.}
\item{jsq}{The \eqn{J_{x,x^2}}{J[x,x^2]} test statistics.}
\item{pvjsq}{The p-values for the \eqn{J_{x,x^2}}{J[x,x^2]} test statistics.}
\item{cab}{The \eqn{C_{x,|x|}}{C[x,|x|]} test statistics.}
\item{pvcab}{The p-values for the \eqn{C_{x,|x|}}{C[x,|x|]} test statistics.}
\item{csq}{The \eqn{C_{x,x^2}}{C[x,x^2]} test statistics.}
\item{pvcsq}{The p-values for the \eqn{C_{x,x^2}}{C[x,x^2]} test statistics.}
}
\description{
The function iid.test computes the test statistics for examining the null hypothesis
of i.i.d. property for univariate series given in Dalla, Giraitis and Phillips (2019).
}
\details{
The \eqn{J_{x,|x|}}{J[x,|x|]} and \eqn{J_{x,x^2}}{J[x,x^2]} statistics are for testing the null hypothesis of i.i.d. at lag \eqn{k}, \eqn{k=1,...,max.lag},
and the \eqn{C_{x,|x|}}{C[x,|x|]} and \eqn{C_{x,x^2}}{C[x,x^2]} statistics are for testing the null hypothesis of i.i.d. at lags \eqn{1,...,m}, \eqn{m=1,...,max.lag}.
}
\note{
Missing values are not allowed.
}
\examples{
x <- rnorm(100)
iid.test(x, max.lag = 10)
}
\references{
Dalla, V., Giraitis, L. and Phillips, P. C. B. (2019). "Robust Tests for White Noise and Cross-Correlation". Cowles Foundation, Discussion Paper No. 2194, \url{https://cowles.yale.edu/sites/default/files/files/pub/d21/d2194.pdf}.
}
\author{
Violetta Dalla, Liudas Giraitis and Peter C. B. Phillips
}
