% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{stat_median_ci}
\alias{stat_median_ci}
\title{Confidence interval for median}
\usage{
stat_median_ci(x, conf_level = 0.95, na.rm = TRUE, gg_helper = TRUE)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{na.rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{gg_helper}{(\code{flag})\cr whether output should be aligned for use with \code{ggplot}s.}
}
\value{
A named \code{vector} of values \code{median_ci_lwr} and \code{median_ci_upr}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Convenient function for calculating the median confidence interval. It can be used as a \code{ggplot} helper
function for plotting.
}
\details{
This function was adapted from \verb{DescTools/versions/0.99.35/source}
}
\examples{
stat_median_ci(sample(10), gg_helper = FALSE)

p <- ggplot2::ggplot(mtcars, ggplot2::aes(cyl, mpg)) +
  ggplot2::geom_point()
p + ggplot2::stat_summary(
  fun.data = stat_median_ci,
  geom = "errorbar"
)

}
