% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equ16.R
\name{equ16}
\alias{equ16}
\title{Equation 16}
\usage{
equ16(temp, rate, augment = F, return_fit = F)
}
\arguments{
\item{temp}{temperature (in Celsius)}

\item{rate}{rate measurement}

\item{augment}{logical wether the dataset with fits should be returned instead of the parameter values}

\item{return_fit}{logical wether the model fit object should be returned}
}
\value{
a data frame of, depending on augment argument, if FALSE, parameters, if TRUE, data with predicted values
}
\description{
Equation from "A Key Marine Diazotroph in a Changing Ocean: The Interacting Effects of Temperature, CO2 and Light on the Growth of Trichodesmium erythraeum IMS101".  Challenging to fit to many datasets.  Does not fit to example dataset.
}
\examples{
output <- with(Emiliania_huxleyi, equ16(temp=temp, rate=rate))
}
