% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{tcata.line.plot}
\alias{tcata.line.plot}
\title{Temporal Check-All-That-Apply (TCATA) curve}
\usage{
tcata.line.plot(X, n = 1, attributes = c(), times = c(), lwd = 1,
emphasis = NA, emphasis.lty = 1, emphasis.lwd = 3, declutter = NA,
chance.lty = 3, reference = NA, ref.lty = 2, ref.lwd = 1,
highlight = FALSE, highlight.lty = 1, highlight.lwd = 5, highlight.col = c(),
height = 8, width = 12, main = "",
xlab = "Time", ylab = "Citation proportion", xlim = c(), las = 0,
line.col = c(), x.increment = 5, legend.cex = 1, legend.pos = "topleft", box = FALSE,
save.format = "", save.as = "" )
}
\arguments{
\item{X}{matrix of proportions (or, if there is no missing data, on counts), typically with Attributes in rows and times in columns.}

\item{n}{The number of observations if \code{X} is a count matrix. Keep \code{n = 1} if \code{X} is a matrix of proportions.}

\item{attributes}{a vector of attribute labels, corresponding to the attributes in \code{X}.}

\item{times}{a vector of time, corresponding to the times in \code{X}.}

\item{lwd}{Line width used when plotting attribute curves in \code{X}.}

\item{emphasis}{a matrix matching \code{X} in its dimensions, with a numeric value corresponding to points requiring emphasis, and \code{NA} for points without emphasis.}

\item{emphasis.lty}{Controls the line type associated with the emphasis line.}

\item{emphasis.lwd}{Controls the line weight associated with the emphasis line.}

\item{declutter}{a matrix matching \code{X} in its dimensions, with a numeric value corresponding to points that will not be plotted.}

\item{chance.lty}{line type for the chance line. (May be deprecated?)}

\item{reference}{a matrix matching \code{X} in its dimensions, with a numeric value corresponding to points where a reference line will be displayed, and \code{NA} for points where no reference line will be shown.}

\item{ref.lty}{\code{reference} line type.}

\item{ref.lwd}{\code{reference} line width.}

\item{highlight}{a matrix matching \code{X} in its dimensions, with a numeric value corresponding to points requiring highlighting, and \code{NA} for points without highlighting}

\item{highlight.lty}{Controls the line type associated with the highlighting.}

\item{highlight.lwd}{Controls the line weight associated with the highlighting line.}

\item{highlight.col}{a vector of colours for attributes corresponding to rows of \code{X}.}

\item{height}{Window height.}

\item{width}{Window width.}

\item{main}{plot title; see \code{\link[graphics]{plot}}.}

\item{xlab}{Label for the x axis.}

\item{ylab}{Label for the y axis.}

\item{xlim}{Permits control of the x limit. Limits can be specified using a vector of 2 (ascending) numbers.}

\item{las}{numeric in {0,1,2,3}; the style of the axis labels. See: \code{\link[graphics]{par}}.}

\item{line.col}{A vector of colors for lines corresponding to rows of \code{X}.}

\item{x.increment}{Specifies the interval between times when labelling the x axis.}

\item{legend.cex}{Used to identify the size of markers shown in the legend..}

\item{legend.pos}{Indicates the location of the legend in the plot. Defaults to \code{"topleft"}.}

\item{box}{draw box around plot area; see: \code{\link[graphics]{box}}}

\item{save.format}{If indicated, this will be the fle type for the save image. Defaults to \code{"eps"} (eps format). Other possible values are \code{""} (not saved) or \code{"png"} (png format).}

\item{save.as}{Filename if the file will be saved.}
}
\description{
Plots TCATA curves based on count or proportion data. Can also be used for plotting Temporal Dominance of Sensations (TDS) curves based on dominance counts or proportions.
}
\examples{
# example using 'syrah' data set
low1 <- t(syrah[seq(3, 1026, by = 6), -c(1:4)])
colnames(low1) <- 10:180
tcata.line.plot(get.smooth(low1), lwd = 2, main = "Low-ethanol wine (Sip 1)")

# example using 'ojtcata' data set
data(ojtcata)
x <- aggregate(ojtcata[, -c(1:4)], list(samp = ojtcata$samp, attribute = ojtcata$attribute), sum)
p.1.checked <- x[x$samp == 1, -c(1:2)]
p.1.eval <- length(unique(ojtcata$cons))
p.not1.checked <- aggregate(x[, -c(1:2)], list(attribute = x$attribute), sum)[, -1]
p.not1.eval <- length(unique(ojtcata$cons)) * (length(unique(ojtcata$samp)) - 1)

# reference lines for contrast products
p.1.refline <- p.not1.checked / p.not1.eval
# decluttering matrix corresponds to the dimensions of p.1.refline
p.1.declutter <- matrix(get.decluttered(x = unlist(p.1.checked), n.x = p.1.eval,
                                        y = unlist(p.not1.checked), n.y = p.not1.eval),
                        nrow = nrow(p.1.checked))
times <- get.times(colnames(x)[-c(1:2)])
attributes <- unique(x$attribute)
palettes <- make.palettes(length(attributes))
tcata.line.plot(p.1.checked, n = p.1.eval, attributes = attributes, times = times,
                reference = p.1.refline, ref.lty = 3, declutter = p.1.declutter,
                highlight = TRUE, highlight.lwd = 4,
                line.col = palettes$pal, highlight.col = palettes$pal.light,
                main = "Sample 1", height = 7, width = 11, legend.cex = 0.7)
}
\references{
Castura, J. C., Antúnez, L., Giménez, A., Ares, G. (2016). Temporal Check-All-That-Apply (TCATA): A Novel Temporal Sensory Method for Characterizing Products. \emph{Food Quality and Preference}, 47, 79-90. \url{http://dx.doi.org/10.1016/j.foodqual.2015.06.017}
}

