% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll_statistics.R
\name{distance_binned_stats}
\alias{distance_binned_stats}
\title{Distance Binned Summary Statistics}
\usage{
distance_binned_stats(
  azi,
  distance,
  n.breaks = 10,
  width.breaks = NULL,
  unc = NULL,
  prd = NULL,
  prd.error = NULL,
  kappa = 2,
  R = 1000,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{azi}{numeric. Azimuth values in degrees.}

\item{distance}{numeric. the independent variable along the values in \code{azi}
are sorted, e.g. the plate boundary distances}

\item{n.breaks}{numeric. number (greater than or equal to 2) giving the
number of equal-sized intervals into which \code{distance} is to be cut.
Default is 10. Will be ignored if \code{width.breaks} is specified.}

\item{width.breaks}{numeric. The width of the intervals into which \code{distance}
is to be cut.}

\item{unc}{(optional) Uncertainties of \code{azi} (in degrees) acting as inverse
weighting factors for statistics.}

\item{prd}{(optional) numeric. A predicted orientation in degrees.}

\item{prd.error}{(optional) numeric. The uncertainty of the predicted
orientation in degrees.}

\item{kappa}{numeric. Concentration parameter applied for the circular mode.}

\item{R}{integer. Number of bootstrap iterates for estimating the error of
the dispersion.}

\item{conf.level}{The level of confidence for confidence interval and
bootstrapped standard error of dispersion.}

\item{...}{optional arguments passed to \code{\link[ggplot2:cut_interval]{ggplot2::cut_interval()}} and [\code{\link[ggplot2:cut_interval]{ggplot2::cut_width()}}}
}
\value{
tibble containing the \code{n} values for \code{azi}in each bin, min/median/max
distance of the bin, and the summary statistics for \code{azi}.
If \code{prd} is specified, the normal Chi-squared statistic, dispersion and its
standard error are returned as well.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Circular summary statistics over intervals of distances.
}
\examples{
data("plates")
plate_boundary <- subset(plates, plates$pair == "na-pa")
data("san_andreas")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
san_andreas$distance <- distance_from_pb(
  x = san_andreas,
  PoR = PoR,
  pb = plate_boundary,
  tangential = TRUE
)
dat <- san_andreas |> cbind(PoR_shmax(san_andreas, PoR, "right"))

distance_binned_stats(dat$azi.PoR,
  distance = dat$distance, width.breaks = 1,
  unc = dat$unc, prd = 135
) |> head()
}
\seealso{
\code{\link[=circular_summary]{circular_summary()}}, \code{\link[=circular_dispersion]{circular_dispersion()}}, and \code{\link[=circular_dispersion_boot]{circular_dispersion_boot()}}
}
