% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{circular_mode}
\alias{circular_mode}
\title{Circular Mode}
\usage{
circular_mode(x, kappa = NULL, axial = TRUE, n = 512)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{kappa}{von Mises distribution concentration parameter. Will be
estimated using \code{\link[=est.kappa]{est.kappa()}} if not provided.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).#' @param kappa}

\item{n}{the number of equally spaced points at which the density is to be estimated.}
}
\value{
numeric
}
\description{
MLE angle (maximum density) using a von Mises distribution kernel with
specified concentration.
}
\examples{
set.seed(1)
x <- rvm(10, 0, 100)
circular_mode(x, kappa = est.kappa(x))
}
