% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContentBlock.R
\docType{class}
\name{ContentBlock}
\alias{ContentBlock}
\title{\code{ContentBlock}: A building block for report content}
\description{
This class represents a basic content unit in a report,
such as text, images, or other multimedia elements.
It serves as a foundation for constructing complex report structures.
}
\examples{

## ------------------------------------------------
## Method `ContentBlock$set_content`
## ------------------------------------------------

ContentBlock <- getFromNamespace("ContentBlock", "teal.reporter")
block <- ContentBlock$new()
block$set_content("Base64 encoded picture")


## ------------------------------------------------
## Method `ContentBlock$get_content`
## ------------------------------------------------

ContentBlock <- getFromNamespace("ContentBlock", "teal.reporter")
block <- ContentBlock$new()
block$get_content()

}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ContentBlock-set_content}{\code{ContentBlock$set_content()}}
\item \href{#method-ContentBlock-get_content}{\code{ContentBlock$get_content()}}
\item \href{#method-ContentBlock-from_list}{\code{ContentBlock$from_list()}}
\item \href{#method-ContentBlock-to_list}{\code{ContentBlock$to_list()}}
\item \href{#method-ContentBlock-clone}{\code{ContentBlock$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContentBlock-set_content"></a>}}
\if{latex}{\out{\hypertarget{method-ContentBlock-set_content}{}}}
\subsection{Method \code{set_content()}}{
Sets content of this \code{ContentBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentBlock$set_content(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{(\code{any}) R object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ContentBlock <- getFromNamespace("ContentBlock", "teal.reporter")
block <- ContentBlock$new()
block$set_content("Base64 encoded picture")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContentBlock-get_content"></a>}}
\if{latex}{\out{\hypertarget{method-ContentBlock-get_content}{}}}
\subsection{Method \code{get_content()}}{
Retrieves the content assigned to this block.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentBlock$get_content()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object stored in a \code{private$content} field
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ContentBlock <- getFromNamespace("ContentBlock", "teal.reporter")
block <- ContentBlock$new()
block$get_content()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContentBlock-from_list"></a>}}
\if{latex}{\out{\hypertarget{method-ContentBlock-from_list}{}}}
\subsection{Method \code{from_list()}}{
Create the \code{ContentBlock} from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentBlock$from_list(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\verb{named list}) with two fields \code{text} and \code{style}.
Use the \code{get_available_styles} method to get all possible styles.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContentBlock-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-ContentBlock-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert the \code{ContentBlock} to a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentBlock$to_list()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{named list} with a text and style.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ContentBlock-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ContentBlock-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ContentBlock$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
