% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/followingCodes.R
\name{followingCodes}
\alias{followingCodes}
\title{Following Codes}
\usage{
followingCodes(tdsc, depth = 2, min_code = 0, max_code = 10,
  plot = F)
}
\arguments{
\item{tdsc}{A TDSC object}

\item{depth}{The length of the sequence of codes to search for}

\item{min_code}{The minimum value of code to include in sequence}

\item{max_code}{The maximum value of code to include in sequence}

\item{plot}{If "alluvial" plots the found sequences in a river plot}
}
\description{
Identifies sequences of codes that follow each other from time domain signal analysis, and optionally plots them as a Sankey diagram.
}
\examples{
library(tuneR)
wave <- readWave(system.file("extdata", "1.wav", package="tdsc"))
t <- tdsc(wave)
followingCodes(t)

}
\keyword{TDSC}
