% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert.to.daily}
\alias{convert.to.daily}
\title{Converts Data to Daily Data}
\usage{
convert.to.daily(variable, aggregateFun = NULL)
}
\arguments{
\item{variable}{A variable.}

\item{aggregateFun}{A function to aggregates the data within each interval (see the datails).}
}
\value{
A variable with daily frequency. Its data is the sorted data of the original variable, while missing dates are filled with \code{NA}.
}
\description{
Use this to convert a time-series data (currently implemented: \code{Date-List}, \code{Daily-In-Week}) to a time-series data with daily frequency.
}
\details{
For some cases, conversion sorts the dates and fills any gaps between them with \code{NA}.
However, in some cases conversion requires an aggregation. For example,
when aggregating hourly data over a period of \code{k} hours to generate daily data,
we expect \code{k} numbers in each interval.
The aggregate function can be set to calculate the mean,
variance, median, ..., or any function that takes
the vector of \code{k} values and returns a number.
}
\examples{
startFreq <- f.list.date(c("20220904","20220901"), "20220901")
v <- variable(c(4,1), startFreq)
w <- convert.to.daily(v)
}
